<?php
class BaseController {
	/**
	 * __call magic method
	 * */
	public function __call($name, $arguments) {
		$this->sendOutput("", "HTTP/1.1 404 Not Found");
	}

	/**
	 * Get URI elements
	 * 
	 * @return array
	 * */
	protected function getUriSegments() {
	 	$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
	 	$uri = explode("/", $uri);

	 	return $uri;
	}

	/**
	 * Get querystring params
	 * 
	 * @return array
	 * */
	protected function getQueryStringParams() {
		if(!empty($_REQUEST))
			return $_REQUEST;
		
	 	return -1;
	}

	
}

$result = [];
$results = [];
$response = [];
// $responseData = [];

function getRequestValue($requestParams, $request, $error_message = null, $default_val = null) {
	$err_msg = (empty($error_message)) ? "invalid entry" : $error_message;

	if(empty($requestParams[$request])) {
		if (!isset($default_val)){
			echo json_encode($err_msg);
			exit;
		} else {
			return $default_val;
		}
	} else {
		return $requestParams[$request];
	}
}

/**
 * Curl API Calls
 * 
 * @param string $_REQUEST
 * @param string $URL
 * @param array $params
*/
function curlAPIRequest($requestMethod = "POST", $url = "", $params = []) {
	$curl = curl_init();

	curl_setopt_array($curl, [
		CURLOPT_URL => WEBSITE_URL . $url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => $requestMethod,
		CURLOPT_POSTFIELDS => $params,
		CURLOPT_HTTPHEADER => [
			"Accept: application/json"
		]
	]);

	$output = curl_exec($curl);

	if(curl_errno($curl)){
		$response = "Curl error: " . curl_error($curl);//curl_getinfo($curl, CURLINFO_HTTP_CODE);
	} else {
		$response = json_decode($output);
	}
	
	curl_close($curl);
	
	return $response;
}


function resultStatus($status_code, $message = null, $output = null){
	$state = [];
	$state["status"] = isset($status_code) ? $status_code : 0;

	if(!empty($message))
		$state["message"] = $message;

	if(!empty($output) || $output != null)
		$state["output"] = $output;
	
	return $state;
}

/**
	 * Send API output
	 * 
	 * @param mixed $data
	 * @param string $httpHeader
	 * */
function sendOutput($data = null, $httpHeader = HTTP_200) {
	echo json_encode($data); 
	exit;
} 

function validatePhoneNumber($phone_no){
	// check if the username is a phone number
	$pattern = "/^[0-9]{10}+$/";
	return preg_match($pattern, $phone_no);
}

function isUserSignedIn(&$user){
	if(isset($_SESSION["USER"])){
		$user = $_SESSION["USER"]; // user info
		return 0;
	}
	
	return 1;
}