<?php
ini_set("error_log", ROOT_PATH . "/tmp/shop.log");

class ShopController extends BaseController {

	// product list
	public function productListAction() {
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();
		
		if(strtoupper($requestMethod) == "GET" && isset($requestParams)) {
			try {
				$shopModel = new ShopModel();

				if(isset($requestParams)) {
					$prodcut_category = getRequestValue(REQ_GET, "product_category", "invalid entry", "all");
					
					// get product list
					$responseData = $shopModel->productList($prodcut_category);

					// convert image list (string) to an array
					if($responseData["status"] == 0){
				// 		for($i = 0; $i < count($responseData["data"]); $i++){
				// 			$prod_photos = $responseData["data"][$i]["product_photos"];
				// 			$prod_photos_arr = explode(",", $prod_photos);
				// 			$responseData["data"][$i]["product_photos"] = $prod_photos_arr;
				// 		}

						$responseData = $responseData["data"];
					} else {
						$responseData = resultStatus(1, "Oops! Sorry. No results found for $prodcut_category");
					}
				}
			} catch (Error $e) {
				$errorMessage = $e->getMessage() . " Something went wrong! Please contact support.";
				$responseData = resultStatus(-1, $errorMessage);
				$strErrorHeader = HTTP_500;
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}
	
	
	// product details
	public function productDetailsAction() {
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();
		
		if(strtoupper($requestMethod) == "GET" && isset($requestParams)) {
			try {
				$shopModel = new ShopModel();

				if(isset($requestParams)) {
					$prodcut_code = getRequestValue(REQ_GET, "product_code", "invalid entry");
					
					// get product details
					$responseData = $shopModel->productDetails($prodcut_code);

					if($responseData["status"] == 0){
				// 		$prod_photos = $responseData["data"][0]["product_photos"];
				// 		$prod_photos_arr = explode(",", $prod_photos);
				// 		$responseData["data"][0]["product_photos"] = $prod_photos_arr;

						$responseData = $responseData["data"];
					} else {
						$responseData = resultStatus(1, "Oops! Sorry. No results found for $prodcut_code");
					}
				}
			} catch (Error $e) {
				$errorMessage = $e->getMessage() . " Something went wrong! Please contact support.";
				$responseData = resultStatus(-1, $errorMessage);
				$strErrorHeader = HTTP_500;
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}


	// order request
	public function orderRequestAction() {
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams($requestMethod);
		
		if(strtoupper($requestMethod) == "POST" && isset($requestParams)) {
			try {
				$shopModel = new ShopModel();

				if(isset($requestParams)) {
					/**
					 * 
					 * @param $order_id
					 * @param $customer_name
					 * @param $customer_phone_no
					 * @param $street_address
					 * @param $order_data [
					 * 	{
					 * 		@param $product_name
					 * 		@param $product_code
					 * 		@param $product_price
					 * 		@param $order_quantity
					 * 		@param $total_amount
					 * 	}
					 * ]
					*/
					
					$customer_phone_no = getRequestValue(REQ_POST, "customer_phone_no", "invalid entry");
					$order_data = getRequestValue(REQ_POST, "order_data", "invalid entry");

					$order_code = "POR-" . rand(1111111, 9999999);
					$order_timestamp = date("Y-m-d H:i:s");

					$params = [
						$order_code, 
						$customer_phone_no, 
						json_encode($order_data), 
						$order_timestamp
					];

					// send order request
					$response = $shopModel->orderRequest($params);
					$response["data"][0]["order_data"] = json_decode($response["data"][0]["order_data"], true);

					if($response["status"] == 0){
					    $order_info = $response["data"][0];
					    
					    $message = "Order Code: " . $order_info["order_code"] . "\r\n";
					    
					    $userModel = new UserModel();
					    $user_data = $userModel->userExistChecker($order_info["customer_phone_no"]);
					    
					    $message .= "Business Name: " . $user_data["data"][0]["business_name"] . "\r\n";
					    $message .= "Phone Number: " . $order_info["customer_phone_no"] . "\r\n";
					    $message .= "Address: " . $user_data["data"][0]["street_address"] . "\r\n\n\n";
					    
					    $order_details = $order_info["order_data"];
					    $order_dets = '';
					    $order_cnt = 1;
					    
					    $message .= "ORDERED ITEMS"."\r\n\n";
					    
					    foreach($order_details as $order){
					        $order_cnt = ($order_cnt < 10) ? "0".$order_cnt : $order_cnt;
					        $order_dets .= "Item " . $order_cnt . "\r\n";
					        $order_dets .= "Product Name: " . $order["product_name"] . "\r\n";
					        $order_dets .= "Product Code: " . $order["product_code"] . "\r\n";
					        $order_dets .= "Price: " . $order["product_price"] . "\r\n";
					        $order_dets .= "Quantity: " . $order["order_quantity"] . "\r\n";
					        $order_dets .= "Total Amount: GHS" . $order["total_amount"] . "\r\n\n";
					        
					        $order_cnt++;
					    }
					    
					    $message .= $order_dets;
					    
                        // Always set content-type when sending HTML email
                        $headers = "MIME-Version: 1.0" . "\r\n";
                        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                        
                        // More headers
                        $headers = 'From: Order Request <no-reply@cbefabrics.com>' . "\r\n";
                        
                        if(mail("orders.cbe@gmail.com", "Order Request Number: {$order_info['order_code']}", $message, $headers)){
                            error_log("order request notification sent for order id: ");
                        }
                        
						$productData = $response["data"];
						$responseData = $productData;
					} else {
						$responseData = resultStatus(1, "Failed to fetch order information");
					}
				}
			} catch (Error $e) {
				$errorMessage = $e->getMessage() . " Something went wrong! Please contact support.";
				$responseData = resultStatus(-1, $errorMessage);
				$strErrorHeader = HTTP_500;
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}
}