<?php
ini_set("error_log", ROOT_PATH . "/tmp/user.log");

class UserController extends BaseController {

	// sign up user
	public function signupAction() {
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();
		
		if(strtoupper($requestMethod) == "POST" && isset($requestParams)) {
			try {
				$userModel = new UserModel();

				// username and password must have values
				if(isset($requestParams)) {
					$business_name = getRequestValue(REQ_POST, "business_name", "Please enter Business Name");
					$phone_no = getRequestValue(REQ_POST, "phone_no", "Please enter Phone Number");
					$password = getRequestValue(REQ_POST, "user_password", "Please enter Password");
					$street_address = getRequestValue(REQ_POST, "street_address", "Please enter Street Address");
					// $first_name = getRequestValue(REQ_POST, "first_name", "invalid entry");
					// $last_name = getRequestValue(REQ_POST, "last_name", "invalid entry");
					// $gender = getRequestValue(REQ_POST, "gender", "invalid entry", "");
					// $city = getRequestValue(REQ_POST, "city", "invalid entry");
					// $region = getRequestValue(REQ_POST, "region", "invalid entry");

					// check if user exists
					$userExistCheckResult = $userModel->userExistChecker($phone_no);
					
                    if($userExistCheckResult['status'] == 2){
                        $responseData = $userExistCheckResult;
                    } elseif($userExistCheckResult['status'] == 1) {
						$signup_timestamp = date("Y-m-d H:i:s");
						// $gender = (strtolower($gender) == "male") ? 1 : 2;
						$crypt_password = md5($password);
						$params = [$business_name, $phone_no, $crypt_password, $street_address, $signup_timestamp];
						
						$responseData = $userModel->signupUser($params, $user);

						if($responseData['status'] == 0) {
							error_log("===>>>successfully signed up new user : ". json_encode($user));
							$responseData = resultStatus(0, "Successfully signed up!");
							$responseData["user_data"] = $user;
						} else {
							$responseData = resultStatus(1, "Sign up failed! Kindly check your credentials and try again.");
						}
					} else {
						$responseData = resultStatus(1, "Account No. {$phone_no} already exits.");
					}
				}
			} catch (Error $e) {
				$errorMessage = $e->getMessage() . " Something went wrong! Please contact support.";
				$responseData = resultStatus(-1, $errorMessage);
				$strErrorHeader = HTTP_500;
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}


	// user sign in
	public function signinAction($params = []) {
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();
		
		if(strtoupper($requestMethod) == "POST" && isset($requestParams)) {
			try {
				$userModel = new UserModel();
				
				// username and password must have values
				if(isset($requestParams)) {
					$username = getRequestValue(REQ_POST, "phone_no", "invalid entry");
					$password = getRequestValue(REQ_POST, "user_password", "invalid entry");
					$userExistCheckResult = $userModel->userExistChecker($username);
					
					if($userExistCheckResult["status"] == 0){
						$user_data = $userExistCheckResult["data"][0];
						$crypt_password = $user_data["user_password"];
						
						if(md5($password) == $crypt_password){
							// set sessions
							$_SESSION["USER"] = $user_data;
							$_SESSION["USERID"] = $user_data["id"];
							$_SESSION["USERNAME"] = $user_data["phone_no"];

							$_SESSION["PHONE_NO"] = $user_data["phone_no"];
							$_SESSION["BUSINESS_NAME"] = $user_data["business_name"];

							if (is_null($_SESSION)){
								$responseData = resultStatus(1, "Oops! Sorry. Sign in failed!");
							} else {
								$responseData = resultStatus(0, "Successfully signed in!");
								$responseData["user_data"] = $user_data;
							}
						} else {
							$responseData = resultStatus(-1, "Wrong phone number and/or password!");
						}
					} else {
						$responseData = resultStatus(1, "Sorry, phone number does not exist!");
					}
				}
			} catch (Error $e) {
				$strErrorDesc = $e->getMessage() . " Something went wrong! Please contact support.";
				$strErrorHeader = "HTTP/1.1 500 Internal Server Error";
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}


	// password reset request
	public function passwordResetRequestAction(){
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();
		
		if(strtoupper($requestMethod) == "POST" && isset($requestParams)) {
			try {
				$userModel = new UserModel();
				
				// username and password must have values
				if(isset($requestParams)) {
					$phone_number = getRequestValue(REQ_POST, "phone_no", "Phone number is required!");

					$userExistCheckResult = $userModel->userExistChecker($phone_number);
					
					if($userExistCheckResult["status"] == 0){
						$user_data = $userExistCheckResult["data"][0];
						
						$reset_code = rand(1111,9999);
						// update the user data with the reset_code
						$params = [$reset_code, $phone_number];
						$response = $userModel->updateUserPasswordRequest($params);

						if($response["status"] == 0){
							$user_phone_number = $user_data["phone_no"];
							$business_name = $user_data["business_name"];
							
							$message = "Hello \r\n\n";
							$message .= "{$business_name} ({$user_phone_number}) is requesting a password reset. \r\n\nRESET CODE: \t\t{$reset_code} \r\n";
					
							// Always set content-type when sending HTML email
							$headers = "MIME-Version: 1.0" . "\r\n";
							$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
							
							// More headers
							$headers = 'From: Password Reset Request <no-reply@cbefabrics.com>' . "\r\n";
							
							if(mail("pwreset.cbe@gmail.com", "Password Reset Request For: {$user_phone_number}", $message, $headers)){
								error_log("password reset request notification sent with reset code: {$reset_code}");
							    $responseData = resultStatus(0, "Successfully sent password reset request.");
							} else {
							    $responseData = resultStatus(1, "Failed. Could not send password reset request at this time. Please try again later.");
							}
						} else {
							$responseData = resultStatus(0, "Failed to send password reset code to email.");
						}
					} else {
						$responseData = resultStatus(1, "Sorry, phone number: {$phone_number} is not a registered user!");
					}
				}
			} catch (Error $e) {
				$strErrorDesc = $e->getMessage() . " Something went wrong! Please contact support.";
				$strErrorHeader = "HTTP/1.1 500 Internal Server Error";
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}


	// password reset
	public function passwordResetAction(){
		// get the 4 digit number from the customer
		// fetch customer data by phone number and compare the 4 digits with what is in the db
		// accept new password and save the new password

		// repond with "Successfully changed password."
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();
		
		if(strtoupper($requestMethod) == "POST" && isset($requestParams)) {
			try {
				$userModel = new UserModel();
				
				// username and password must have values
				if(isset($requestParams)) {
					$phone_number = getRequestValue(REQ_POST, "phone_no", "Phone number is required!");
					$reset_code = getRequestValue(REQ_POST, "reset_code", "Reset code is required!");
					$new_password = getRequestValue(REQ_POST, "new_password", "New password is required!");

					$userExistCheckResult = $userModel->userExistChecker($phone_number);
					
					if($userExistCheckResult["status"] == 0){
						$user_data = $userExistCheckResult["data"][0];
						
						if($user_data["reset_code"] == $reset_code){
							$new_crypt_password = md5($new_password);
							// update the user data with the reset_code
							$params = [$new_crypt_password, $phone_number, $reset_code];
							$response = $userModel->updateUserPassword($params);

							if($response["status"] == 0){
								$responseData = resultStatus(0, "Password reset successful.");
							} else {
								$responseData = resultStatus(0, "Password reset failed.");
							}
						} else {
							$responseData = resultStatus(1, "Wrong reset code.");
						}
						

						
					} else {
						$responseData = resultStatus(1, "Sorry, phone number: {$phone_number} is not a registered user!");
					}
				}
			} catch (Error $e) {
				$strErrorDesc = $e->getMessage() . " Something went wrong! Please contact support.";
				$strErrorHeader = "HTTP/1.1 500 Internal Server Error";
			}
		} else {
			$responseData = resultStatus(1, "Method not supported");
			$strErrorHeader = HTTP_422;
		}

		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}




	// user sign in
	public function updateAction() {
		$strErrorDesc = "";
		$requestMethod = $_SERVER['REQUEST_METHOD'];
		$requestParams = $this->getQueryStringParams();

		exit;
	}

	public function signoutAction(){
		// if(isset($_SESSION) || isUserSignedIn($user)) {
			session_destroy();
			// if(is_null($_SESSION))
				$responseData = resultStatus(0, "Successfully signed out!");
		// 	else
		// 		$responseData = resultStatus(1, "Unable to sign out. Kindly try again.");
		// } else {
		// 	$responseData = resultStatus(1, "Sorry! Already signed out.");
		// }
		// send output
		sendOutput($responseData, $strErrorHeader ?? null);
	}
}
