<?php
class Database {
	protected $connection = null;

	public function __construct() {
		try {
			$this->connection = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_DATABASE_NAME);

			if(mysqli_connect_errno()) {
				throw new Exception("Could not connect to database");
			}
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
	}


	// select query
	public function select($query = "", $params = []) {
		try {
			$stmt = $this->executeStatement($query, $params);
			$data = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
			$stmt->close();

			$result = array();
			if(count($data)) {
				$result['status'] = 0;
				$result['message'] = "Success!";
				$result['data'] = $data;
			} else {
				$result['status'] = 1;
				$result['message'] = "Failed!";
			}

		} catch(Exception $e) {
			$result['status'] = -1;
			$result['message'] = "Fatal error!";
			throw new Exception($e->getMessage()); 
		}

		return $result;
	}


	// insert query
	public function insert($query = "", $params = []) {
		try {
			$stmt = $this->executeStatement($query, $params);
			// $data = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
			$stmt->close();
			
			$result = array();
			if($stmt) {
				return 0;
			} else {
				return 1;
			}

		} catch(Exception $e) {
			$result['status'] = -1;
			$result['message'] = "Fatal error!";
			throw new Exception($e->getMessage()); 
		}

		return $result;
	}


	// update query
	public function update($query = "", $params = []) {
		try {
			$stmt = $this->executeStatement($query, $params);
			$stmt->close();
			
			$result = array();
			if($stmt) {
				$result['status'] = 0;
				$result['message'] = "Success! Record updated.";
				error_log("successfully updated record");
			} else {
				$result['status'] = 1;
				$result['message'] = "Failed! Could not be updated.";
				error_log("failed to updated record");
			}

		} catch(Exception $e) {
			$result['status'] = -1;
			$result['message'] = "Fatal error!";
			throw new Exception($e->getMessage()); 
		}

		return $result;
	}


	private function executeStatement($query = "", $params = []) {
		try {
			$stmt = $this->connection->prepare($query);

			if($stmt === false) {
				throw new Exception ("Unable to do prepared statement: " . $query);
			}

			if($params) {
				$count_params = count((array)$params);
				$varTypes = str_repeat("s", $count_params);
				if($count_params > 1)
					$stmt->bind_param($varTypes, ...$params);
				else
					$stmt->bind_param($varTypes, $params);
			}

			$stmt->execute();
			return $stmt;
		} catch(Exception $e) {
			throw new Exception($e->getMessage());
		}
	}
}

