<?php
require_once ROOT_PATH . "/Models/Database.php";
ini_set("error_log", ROOT_PATH . "/tmp/shop.log");

class ShopModel extends Database {

	// product list
	public function productList($product_category) {
        if($product_category == "all"){
            $result = $this->select("SELECT * FROM products");
        } else {
            $result = $this->select("SELECT * FROM products WHERE product_category = ?", $product_category);
        }

		return $result;
	}
    
    // product details
	public function productDetails($product_code = null) {
        if(!is_null($product_code) || !empty($product_code)){
            $result = $this->select("SELECT * FROM products WHERE product_code = ?", $product_code);
        }

		return $result;
	}

    // order request
	public function orderRequest($params = null) {
        /**
         * Order Request Params
         * 
         * @param string order_code
         * @param string customer_phone_no
         * @param string order_data
         * @param string order_timestamp
        */

        $resCode = $this->insert("INSERT INTO order_request SET 
            order_code = ?,
            customer_phone_no = ?,
            order_data = ?,
            order_timestamp = ?",  
        $params);

        if($resCode == 0){
            // get product information
            $responseData = $this->select("SELECT * FROM order_request WHERE order_code = ?", $params[0]);
        }

        return $responseData;
        // if($resCode == 0){
        //     $result["order_id"] = $params[2];
        //     $result["order_quantity"] = $params[3];
        //     $result["total_cost"] = "GHS" . $params[4];

        //     // get product information
        //     $responseData = $this->select("SELECT * FROM products WHERE product_code = ?", $params[0]);

        //     if($responseData["status"] == 0){
        //         $result["product_info"] = [
        //             "product_info_status" => "PRODUCT_FOUND",
        //             "product_data" => $responseData["data"]
        //         ];
        //     } else {
        //         $result["product_info"] = [
        //             "product_info_status" => "PRODUCT_NOT_FOUND", 
        //             "product_data" => "No data found!"
        //         ];
        //     }

        //     // get customer information
        //     $responseData = $this->select("SELECT * FROM users WHERE phone_no = ?", $params[1]);

        //     if($responseData["status"] == 0){
        //         $result["customer_info"] = [
        //             "customer_info_status" => "IS_CUSTOMER",
        //             "customer_data" => $responseData["data"]
        //         ];
        //     } else {
        //         $result["customer_info"] = [
        //             "customer_info_status" => "NOT_CUSTOMER", 
        //             "customer_data" => "No data found!"
        //         ];
        //     }
        // }



		// return $result = $resCode;
	}
}

