<?php
require_once ROOT_PATH . "/Models/Database.php";
ini_set("error_log", ROOT_PATH . "/tmp/user.log");

class UserModel extends Database {

	// sign in user
	public function signupUser($params, &$user) {
		
		$resCode = $this->insert("INSERT INTO users SET 
			business_name = ?,
			phone_no = ?, 
			user_password = ?, 
			street_address = ?,
			signup_timestamp = ?",  
			$params);

		if ($resCode == 0){
			// fetch the new user info
			$phone_no = $params[1];
			$result = $this->select("SELECT * FROM users WHERE phone_no = ?", $phone_no);
			$user_data = $result['data'][0];

			if(!empty($user_data)){
			    
				$user = [
					"user_id" => $user_data['id'],
					"business_name" => $user_data['business_name'],
					"phone_no" => $user_data['phone_no'], 
					"user_password" => $user_data['user_password'],
					"street_address" => $user_data['street_address'],
					"signup_timestamp" => $user_data['signup_timestamp']
				];
				error_log("new user data: " . json_encode($user_data));
			} else {
				error_log("failed to fetch user data for $phone_no");
				
			}
			return $result;
		}
	}


	// sign in user
	public function signinUser($username, $password) {
		if(validatePhoneNumber($username)){
			$params = array(
				$username,
				$password
			); 
			
			return $this->select("SELECT * FROM users WHERE phone_no = ?", $params);
		}
	}


	// update user
	public function updateUser($username, $password, $email) {
		$params = array(
			$username,
			$password,
			$email
		); 

		return $this->update("UPDATE users SET username = ?, user_password = ? WHERE user_email = ?", $params);
	}


	// user password request
	public function updateUserPasswordRequest($params){
		return $this->update("UPDATE users SET reset_code = ? WHERE phone_no = ?", $params);
	}


	// reset password
	public function updateUserPassword($params){
		return $this->update("UPDATE users SET user_password = ? WHERE phone_no = ? AND reset_code = ?", $params);
	}




	// confirm email
// 	public function confirmEmail($verify_email_code){
// 		$result = $this->select("SELECT * FROM users WHERE verified_email = ?", $verify_email_code);
// 		$user_data = $result['data'][0];

// 		if(!empty($user_data)){
// 			$user = [
// 				"user_id" => $user_data['id'],
// 				"svrtid" => $user_data['svrtid'],
// 				"first_name" => $user_data['first_name'],
// 				"last_name" => $user_data['last_name'], 
// 				"dob" => $user_data['dob'],
// 				"gender" => $user_data['gender'],
// 				"username" => $user_data['username'], 
// 				"user_email" => $user_data['user_email'],
// 				"account_type" => $user_data['account_type'], 
// 				"account_status" => $user_data['account_status']
// 			];
// 		}

// 		if(!is_null($user)){
// 			$this->update("UPDATE users SET verified_email = ? WHERE user_email = ?", $verify_email_code);
// 		}
// 	}

	// does user exists?
	public function userExistChecker($username) {
		if (validatePhoneNumber($username)){
			$result = $this->select("SELECT * FROM users WHERE phone_no = ?", $username);
		} else {
			$result = resultStatus(2, "Invalid Phone Number!");
		}

		return $result;
	}
}

