<?php
session_start();

header_remove("Set-Cookie");
header("Content-type: application/json");

header("HTTP/1.1 200 OK");
ini_set("log_errors", 1);

define("ROOT_PATH", __DIR__ . "/../");
define("WEBSITE_URL", "https://cbeapi.cbefabrics.com");

$requestMethod = $_SERVER['REQUEST_METHOD'];
$data = json_decode(file_get_contents('php://input'), true);
switch ($requestMethod) {
    case 'POST':
        $_POST = empty($data) ? $_POST : $data;
        break;
    case 'GET':
        $_GET = empty($data) ? $_GET : $data;
        break;
    
    default:
        $_REQUEST = empty($data) ? $_GET : $data;
        break;
}

// autoload
require ROOT_PATH . "vendor/autoload.php";

// include main configuration file
require_once (ROOT_PATH . "inc/config.php");

// include the base controller file
require_once (ROOT_PATH . "Controllers/Api/BaseController.php");

// include the base controller file
require_once (ROOT_PATH . "Controllers/Api/DBController.php");

// include the user model file
require_once (ROOT_PATH . "Models/UserModel.php");

// include the shop model file
require_once (ROOT_PATH . "Models/ShopModel.php");

